local mod = RegisterMod("Test", 1)

local game = Game()

local ID =
{
    BOMB_STONEY = Isaac.GetEntityTypeByName("Bomb Stoney"),
    PSY_GRIMACE = Isaac.GetEntityTypeByName("Psy Grimace")
}

local BULLET_SPEED = 6

---@param proj EntityProjectile
function mod:EnemyProjFixer(proj)
    if proj.SpawnerEntity.Type == 42 and proj.SpawnerEntity.Variant == 3 then
        proj.ProjectileFlags = ProjectileFlags.SMART
    elseif proj.SpawnerEntity.Type == 42 and proj.SpawnerEntity.Variant == 4 then
        proj.FallingSpeed = -100
        proj.FallingAccel = 100
        proj.ProjectileFlags = ProjectileFlags.EXPLODE
    elseif proj.SpawnerEntity.Type == 42 and proj.SpawnerEntity.Variant == 1 then
        print(proj.FallingSpeed)
        print(proj.FallingAccel)
    end
end

mod:AddCallback(ModCallbacks.MC_POST_PROJECTILE_INIT, mod.EnemyProjFixer)

---@param bs EntityNPC
function mod:BombStoneyExplode(bs)
    if bs.Variant == 2 then
        Isaac.Explode(bs.Position, bs, 100)
    end
end

mod:AddCallback(ModCallbacks.MC_POST_NPC_DEATH, mod.BombStoneyExplode, ID.BOMB_STONEY)