local mod = RegisterMod("Custom Challenges API", 1)

local game = Game()

local MOM_ID = 6 --bossID of Mom
local LIVES_ID = 25 --bossID of It Lives!, we assume Hush/Delirium challenges can't be played if Mom's Heart is still active
local HUSHBOSS_ID = 63 --bossID of Hush
local GREED_ID = 62 --bossID of Ultra Greed
local GREEDIER_ID = 71 --bossID of Ultra Greedier

local GULPER_ID = Isaac.GetItemIdByName("CHALLENGEAPI_GULPER")
local HUSH_ID = Isaac.GetItemIdByName("CHALLENGE_API_HUSH")
local DELI_ID = Isaac.GetItemIdByName("CHALLENGEAPI_DELI")
local BEAST_ID = Isaac.GetItemIdByName("CHALLENGEAPI_BEAST")

local sweep = false

function mod:DoorSpawner()
    if Isaac.GetChallenge() ~= 0 then
        local room = game:GetRoom()
        local endstage = game:GetChallengeParams():GetEndStage()
        if room:GetBossID() == MOM_ID and endstage == LevelStage.STAGE8 then
            game:StartStageTransition(true, 5)
        elseif room:GetBossID() == LIVES_ID and (endstage == LevelStage.STAGE4_3 or endstage == LevelStage.STAGE7) then
            room:TrySpawnBlueWombDoor(false, true)
            sweep = true
        elseif room:GetBossID() == HUSHBOSS_ID and endstage == LevelStage.STAGE7 then
            sweep = true
        elseif room:GetBossID() == GREED_ID or room:GetBossID() == GREEDIER_ID then
            Isaac.Spawn(5, 370, 0, room:GetCenterPos(), Vector.Zero, nil)
        end
    end
end

mod:AddCallback(ModCallbacks.MC_PRE_SPAWN_CLEAN_AWARD, mod.DoorSpawner)

function mod:SweepTrapDoors()
    if sweep then
        local room = game:GetRoom()

        local s = room:GetGridSize()
        local grid
        local sweepend = false

        for i = 1, s do
            grid = room:GetGridEntity(i)
            if grid ~= nil and grid.Desc.Type == GridEntityType.GRID_TRAPDOOR then
                sweepend = true
                room:RemoveGridEntity(i, 0, false)
            end
        end

        if sweepend then sweep = false end
    end
end

mod:AddCallback(ModCallbacks.MC_POST_UPDATE, mod.SweepTrapDoors)

function mod:OnStart(continued)
    if not continued then
        local player = game:GetPlayer(0)
        if player:HasCollectible(GULPER_ID, true, true) then
            local tid = player:GetTrinket(0)
            if tid ~= 0 then
                player:AddSmeltedTrinket(tid)
                player:TryRemoveTrinket(tid)
            end
            tid = player:GetTrinket(1)
            if tid ~= 0 then
                player:AddSmeltedTrinket(tid)
                player:TryRemoveTrinket(tid)
            end
            player:RemoveCollectible(GULPER_ID)
        end

        if Isaac.GetChallenge() ~= 0 then
            local endstage = game:GetChallengeParams():GetEndStage()
            if endstage == LevelStage.STAGE4_3 then
                player:AddCollectible(HUSH_ID)
            elseif endstage == LevelStage.STAGE7 then
                player:AddCollectible(DELI_ID)
            elseif endstage == LevelStage.STAGE8 then
                player:AddCollectible(BEAST_ID)
            end
        end
    end
end

mod:AddCallback(ModCallbacks.MC_POST_GAME_STARTED, mod.OnStart)

---@param beast EntityNPC
function mod:BeastUpdate(beast)
    if beast:GetSprite():IsPlaying("Death") then
        game:FinishChallenge()
    end
end

mod:AddCallback(ModCallbacks.MC_NPC_UPDATE, mod.BeastUpdate, EntityType.ENTITY_BEAST)